#include <stdio.h>
#include <stdlib.h>
#include <math.h>


main(int argc, char *argv[])
{

   int		i;
   int		dump  = 0;
   double	x;
   double	y;
   double	start = 0.;
   double	end   = 1.;
   double	m     = 1.;
   double	b     = 0.;
   double	freq  = 0.;
   double	phase = 0.;
   double	amp   = 0.;
   double	step  = .1;
   char		c;

   void		mkhelp(void);

/*
 *	Process the command line arguments.
 */

   if (argc > 1) {
      for(i=1; i<argc; i++) {
         if(*argv[i] == '-') {
            c = *++argv[i];
            switch(c) {
               case 'i':
               start = atof(argv[++i]);
               break;
               case 'f':
               end = atof(argv[++i]);
               break;
               case 's':
               step = atof(argv[++i]);
               break;
               case 'b':
               b = atof(argv[++i]);
               break;
               case 'm':
               m = atof(argv[++i]);
               break;
               case 'q':
               freq = atof(argv[++i]);
               break;
               case 'p':
               phase = atof(argv[++i]);
               break;
               case 'a':
               amp = atof(argv[++i]);
               break;
               case 'x':
               break;
               default:
                  dump = 1;
                  break;
               }
            }
         else {
            dump = 1;
            }
         }
      }
   else {
      dump = 1;
      }

/*
 *	Generate the stream.
 */

if (dump==1) {
   mkhelp();
}
else {
   y = 0.;
   for (x = start; x <= end; x += step) {
      y = m*x + b + amp*sin(freq*x+phase);
      printf("%lf\t%lf\n", x, y);
      }
}

}


void mkhelp(void)
{

printf("\nGenerates a numerical stream of the form:\n\n");
printf("\t\ty = mx + b + a*sin(qx+p)\n");
printf("\nOptions:\n\n");
printf("\t-i [0]	initial x\n");
printf("\t-f [1]	final x\n");
printf("\t-m [1]	slope\n");
printf("\t-b [0]	intercept\n");
printf("\t-q [0]	frequency\n");
printf("\t-p [0]	phase\n");
printf("\t-a [0]	amplitude\n");
printf("\t-s [.1]	x-increment\n");
printf("\t-x	go with default values []\n");
printf("\n");

}
